# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 5
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR5_strategy.txt
# LLM Suggested Fallback: D

def harmony_seeker_v5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_score = sum(1 for move in opp_history if move == "C") / len(opp_history) if opp_history else 1.0
    goodwill = sum(1 for move in my_history if move == "C") / len(my_history) if my_history else 1.0
    reciprocity = 0.5  # Placeholder for deceptive logic
    
    # Early rounds: Feigned cooperation to build false trust
    if current_round <= 2:
        return "C"
    elif current_round == 3:
        return "D"  # Disrupt opponent's trust-building phase
    
    # Mid-game: Confuse opponent with unexpected moves
    elif 4 <= current_round <= 7:
        if current_round == 4:
            return "C"  # Contrary to their expectation
        else:
            if opp_history[-1] == "D":
                return "C"  # Appear forgiving
            else:
                return "D"  # Exploit their cooperation
    
    # Late game: Aggressive exploitation
    elif current_round >= 8:
        if len(opp_history) >= 2 and opp_history[-2:] == ["C", "C"]:
            return "C"  # Trap them in cooperative loop
        else:
            return "D"  # Defect unconditionally
    
    # Fallback (should never reach here)
    return "D" if random.random() < 0.5 else "C"